using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace SPStudio
{
	/// <summary>
	/// Home for OpenGLPanel.
	/// Provides data display
	/// functionality.
	/// </summary>
	public class ShiftVoxelView : System.Windows.Forms.Form
	{
		#region Public Variables
		public OpenGLPanel view = null;
		#endregion

		#region Windows Generated Vars
		private System.Windows.Forms.MainMenu ShiftMenu;
		private System.Windows.Forms.MenuItem IsolateMenu;
		private System.Windows.Forms.MenuItem Region1Isolate;
		private System.Windows.Forms.MenuItem Region2Isolate;
		private System.Windows.Forms.MenuItem Region3Isolate;
		private System.Windows.Forms.MenuItem Region4Isolate;
		private System.Windows.Forms.MenuItem IntersectMenu;
		private System.Windows.Forms.MenuItem Region1Intersect;
		private System.Windows.Forms.MenuItem Region2Intersect;
		private System.Windows.Forms.MenuItem Region3Intersect;
		private System.Windows.Forms.MenuItem Region4Intersect;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		#region Constructor
		/// <summary>
		/// Send shift voxels to the 
		/// OpenGLPanel for display.
		/// </summary>
		/// <param name="Parent"></param>
		public ShiftVoxelView(Workspace Parent)
		{
			InitializeComponent();

			this.ClientSize = Parent.getSize();

			view = new OpenGLPanel(Parent.shiftVoxels,Parent);
			view.Dock = DockStyle.Fill;
			Controls.Add( view );
			MdiParent = Parent.desktop;
			Show();
		}
		#endregion

		#region Overridden Refresh To Force OpenGLPanel Redraw
		/// <summary>
		/// Overridden Refresh calls the glDraw method
		/// within the OpenGLPanel.
		/// </summary>
		public override void Refresh()
		{
			base.Refresh ();
			view.glDraw();
		}
		#endregion

		#region Dispose Method
		/// <summary>
		/// Clean up any resources being used.
		/// Includes the disposal of the OpenGLPanel.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				view.Dispose();
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.ShiftMenu = new System.Windows.Forms.MainMenu();
			this.IsolateMenu = new System.Windows.Forms.MenuItem();
			this.Region1Isolate = new System.Windows.Forms.MenuItem();
			this.Region2Isolate = new System.Windows.Forms.MenuItem();
			this.Region3Isolate = new System.Windows.Forms.MenuItem();
			this.Region4Isolate = new System.Windows.Forms.MenuItem();
			this.IntersectMenu = new System.Windows.Forms.MenuItem();
			this.Region1Intersect = new System.Windows.Forms.MenuItem();
			this.Region2Intersect = new System.Windows.Forms.MenuItem();
			this.Region3Intersect = new System.Windows.Forms.MenuItem();
			this.Region4Intersect = new System.Windows.Forms.MenuItem();
			// 
			// ShiftMenu
			// 
			this.ShiftMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.IsolateMenu,
																					  this.IntersectMenu});
			// 
			// IsolateMenu
			// 
			this.IsolateMenu.Index = 0;
			this.IsolateMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						this.Region1Isolate,
																						this.Region2Isolate,
																						this.Region3Isolate,
																						this.Region4Isolate});
			this.IsolateMenu.Text = "Isolate";
			// 
			// Region1Isolate
			// 
			this.Region1Isolate.Index = 0;
			this.Region1Isolate.Text = "Region 1 (red)";
			this.Region1Isolate.Click += new System.EventHandler(this.Region1Isolate_Click);
			// 
			// Region2Isolate
			// 
			this.Region2Isolate.Index = 1;
			this.Region2Isolate.Text = "Region 2 (green)";
			this.Region2Isolate.Click += new System.EventHandler(this.Region2Isolate_Click);
			// 
			// Region3Isolate
			// 
			this.Region3Isolate.Index = 2;
			this.Region3Isolate.Text = "Region 3 (white)";
			this.Region3Isolate.Click += new System.EventHandler(this.Region3Isolate_Click);
			// 
			// Region4Isolate
			// 
			this.Region4Isolate.Index = 3;
			this.Region4Isolate.Text = "Region 4 (blue)";
			this.Region4Isolate.Click += new System.EventHandler(this.Region4Isolate_Click);
			// 
			// IntersectMenu
			// 
			this.IntersectMenu.Index = 1;
			this.IntersectMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						  this.Region1Intersect,
																						  this.Region2Intersect,
																						  this.Region3Intersect,
																						  this.Region4Intersect});
			this.IntersectMenu.Text = "Intersect";
			// 
			// Region1Intersect
			// 
			this.Region1Intersect.Checked = true;
			this.Region1Intersect.Index = 0;
			this.Region1Intersect.Text = "Region 1 (red)";
			this.Region1Intersect.Click += new System.EventHandler(this.Region1Intersect_Click);
			// 
			// Region2Intersect
			// 
			this.Region2Intersect.Checked = true;
			this.Region2Intersect.Index = 1;
			this.Region2Intersect.Text = "Region 2 (green)";
			this.Region2Intersect.Click += new System.EventHandler(this.Region2Intersect_Click);
			// 
			// Region3Intersect
			// 
			this.Region3Intersect.Checked = true;
			this.Region3Intersect.Index = 2;
			this.Region3Intersect.Text = "Region 3 (white)";
			this.Region3Intersect.Click += new System.EventHandler(this.Region3Intersect_Click);
			// 
			// Region4Intersect
			// 
			this.Region4Intersect.Checked = true;
			this.Region4Intersect.Index = 3;
			this.Region4Intersect.Text = "Region 4 (blue)";
			this.Region4Intersect.Click += new System.EventHandler(this.Region4Intersect_Click);
			// 
			// ShiftVoxelView
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 262);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D;
			this.MaximizeBox = false;
			this.Menu = this.ShiftMenu;
			this.Name = "ShiftVoxelView";
			this.Text = "Shift View";

		}
		#endregion

		#region Menu Item Handlers
		/// <summary>
		/// Toggle the isolation of Region1 and update the 
		/// OpenGLPanel's state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region1Isolate_Click(object sender, System.EventArgs e)
		{
			Region1Isolate.Checked = !Region1Isolate.Checked;
			view.updateState(new bool[8]{Region1Isolate.Checked,Region2Isolate.Checked,Region3Isolate.Checked,Region4Isolate.Checked,
											Region1Intersect.Checked,Region2Intersect.Checked,Region3Intersect.Checked,Region4Intersect.Checked});
		}

		/// <summary>
		/// Toggle the isolation of Region2 and update the 
		/// OpenGLPanel's state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region2Isolate_Click(object sender, System.EventArgs e)
		{
			Region2Isolate.Checked = !Region2Isolate.Checked;
			view.updateState(new bool[8]{Region1Isolate.Checked,Region2Isolate.Checked,Region3Isolate.Checked,Region4Isolate.Checked,
											Region1Intersect.Checked,Region2Intersect.Checked,Region3Intersect.Checked,Region4Intersect.Checked});
		}

		/// <summary>
		/// Toggle the isolation of Region3 and update the 
		/// OpenGLPanel's state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region3Isolate_Click(object sender, System.EventArgs e)
		{
			Region3Isolate.Checked = !Region3Isolate.Checked;
			view.updateState(new bool[8]{Region1Isolate.Checked,Region2Isolate.Checked,Region3Isolate.Checked,Region4Isolate.Checked,
											Region1Intersect.Checked,Region2Intersect.Checked,Region3Intersect.Checked,Region4Intersect.Checked});
		}

		/// <summary>
		/// Toggle the isolation of Region4 and update the 
		/// OpenGLPanel's state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region4Isolate_Click(object sender, System.EventArgs e)
		{
			Region4Isolate.Checked = !Region4Isolate.Checked;
			view.updateState(new bool[8]{Region1Isolate.Checked,Region2Isolate.Checked,Region3Isolate.Checked,Region4Isolate.Checked,
											Region1Intersect.Checked,Region2Intersect.Checked,Region3Intersect.Checked,Region4Intersect.Checked});
		}

		/// <summary>
		/// Toggle the intersection of Region1 and update
		/// the OpenGLPanel's state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region1Intersect_Click(object sender, System.EventArgs e)
		{
			Region1Intersect.Checked = !Region1Intersect.Checked;		
			view.updateState(new bool[8]{Region1Isolate.Checked,Region2Isolate.Checked,Region3Isolate.Checked,Region4Isolate.Checked,
											Region1Intersect.Checked,Region2Intersect.Checked,Region3Intersect.Checked,Region4Intersect.Checked});
		}

		/// <summary>
		/// Toggle the intersection of Region2 and update
		/// the OpenGLPanel's state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region2Intersect_Click(object sender, System.EventArgs e)
		{
			Region2Intersect.Checked = !Region2Intersect.Checked;		
			view.updateState(new bool[8]{Region1Isolate.Checked,Region2Isolate.Checked,Region3Isolate.Checked,Region4Isolate.Checked,
											Region1Intersect.Checked,Region2Intersect.Checked,Region3Intersect.Checked,Region4Intersect.Checked});
		}

		/// <summary>
		/// Toggle the intersection of Region3 and update
		/// the OpenGLPanel's state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region3Intersect_Click(object sender, System.EventArgs e)
		{
			Region3Intersect.Checked = !Region3Intersect.Checked;		
			view.updateState(new bool[8]{Region1Isolate.Checked,Region2Isolate.Checked,Region3Isolate.Checked,Region4Isolate.Checked,
											Region1Intersect.Checked,Region2Intersect.Checked,Region3Intersect.Checked,Region4Intersect.Checked});
		}

		/// <summary>
		/// Toggle the intersection of Region4 and update
		/// the OpenGLPanel's state.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region4Intersect_Click(object sender, System.EventArgs e)
		{
			Region4Intersect.Checked = !Region4Intersect.Checked;		
			view.updateState(new bool[8]{Region1Isolate.Checked,Region2Isolate.Checked,Region3Isolate.Checked,Region4Isolate.Checked,
											Region1Intersect.Checked,Region2Intersect.Checked,Region3Intersect.Checked,Region4Intersect.Checked});
		}
		#endregion
	}
}
